from typing import List

def menu(choix: List[int]) -> int:
  """
  Affiche un menu et renvoi le choix de l'utilisateur.
  @param choix la liste des possibilités
  @return l'option choisie, comprise entre 1 et len(choix)
  """
  assert len(choix) != 0
  valide = False
  while not valide:
    for i in range(len(choix)):
      print(str(i+1) + ". " + choix[i])
    saisie = input("Votre choix : ")
    if saisie.isdigit() and int(saisie) >= 1 and int(saisie) <= len(choix):
      valide = True
      choix = int(saisie)
    else:
      print("Erreur : choix '" + saisie + "' invalide.\n")
  return choix

if __name__ == "__main__":
  print(menu(["Python", "HTML / CSS"]))
